<?php $__env->startSection('panel'); ?>
    <section>
        <?php echo $__env->make('admin.partials.filter', [
            'is_filter' => false,
            'is_modal' => true,
            'urls' => [
                [
                    'type' => 'modal',
                    'id' => 'investmentCommissionModal',
                    'name' => 'Investment Commission Setting',
                    'icon' => "<i class='las la-cog'></i>"
                ],
                [
                   'type' => 'modal',
                   'id' => 'addAgentModal',
                   'name' => __('Add New'),
                   'icon' => "<i class='las la-plus'></i>"
               ],
            ]
        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo $__env->make('admin.partials.table', [
            'columns' => [
                'created_at' => __('admin.table.joined'),
                'name' => __('admin.table.name'),
                'email' => __('admin.table.email'),
                'agent_primary_balance' => 'Balance',
                'user_add_subtract' => __('admin.table.add_subtract'),
                'status' => __('admin.table.status'),
                'agent_action' => __('admin.table.action'),
            ],
            'rows' => $agents,
            'page_identifier' => \App\Enums\PageIdentifier::AGENT->value,
       ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </section>

    <div class="modal fade" id="investmentCommissionModal" tabindex="-1" aria-labelledby="credit-add-return" aria-hidden="true">
        <div class="modal-dialog modal-xl">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo e(__('Agent Investment Commission Setting')); ?></h5>
                </div>
                <form action="<?php echo e(route('admin.agent.investment.setting')); ?>" method="POST">
                    <?php echo method_field('PUT'); ?>
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="id" value="">
                    <div class="modal-body">
                        <div class="row">
                            <h5 class="mt-4 my-3"><?php echo e(__('Fixed & Percentage Commission Settings')); ?></h5>

                            <!-- Fixed Commission Status -->
                            <div class="col-lg-6 mb-3">
                                <label for="fixed-status" class="form-label"><?php echo e(__('Fixed Commission Status')); ?> <sup class="text--danger">*</sup></label>
                                <select class="form-select shadow-sm" name="agent_investment_commission[fixed_commission][status]" id="fixed-status" required>
                                    <?php $__currentLoopData = \App\Enums\Status::toArray(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($status); ?>" <?php echo e(getArrayValue($setting->agent_investment_commission,'fixed_commission.status') == $status ? 'selected' : ''); ?>>
                                            <?php echo e(\App\Enums\Status::getName($status)); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>

                            <!-- Fixed Amount -->
                            <div class="col-lg-6 mb-3">
                                <label for="fixed-amount" class="form-label"><?php echo e(__('Fixed Amount')); ?> <sup class="text--danger">*</sup></label>
                                <div class="input-group shadow-sm">
                                    <input type="number" class="form-control" id="fixed-amount" name="agent_investment_commission[fixed_commission][bonus]" placeholder="<?php echo e(__('admin.placeholder.number')); ?>" aria-label="Fixed Amount" aria-describedby="fixed-amount-addon" value="<?php echo e(getArrayValue($setting->agent_investment_commission,'fixed_commission.bonus')); ?>">
                                    <span class="input-group-text" id="fixed-amount-addon"><?php echo e(getCurrencyName()); ?></span>
                                </div>
                            </div>

                            <!-- Percentage Commission Status -->
                            <div class="col-lg-6 mb-3">
                                <label for="percentage-status" class="form-label"><?php echo e(__('Percentage Commission Status')); ?> <sup class="text--danger">*</sup></label>
                                <select class="form-select shadow-sm" name="agent_investment_commission[percentage_commission][status]" id="percentage-status" required>
                                    <?php $__currentLoopData = \App\Enums\Status::toArray(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($status); ?>" <?php echo e(getArrayValue($setting->agent_investment_commission,'percentage_commission.status') == $status ? 'selected' : ''); ?>>
                                            <?php echo e(\App\Enums\Status::getName($status)); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>

                            <!-- Percentage Commission -->
                            <div class="col-lg-6 mb-3">
                                <label for="percentage-commission" class="form-label"><?php echo e(__('Percentage Commission')); ?> <sup class="text--danger">*</sup></label>
                                <div class="input-group shadow-sm">
                                    <input type="number" class="form-control" id="percentage-commission" name="agent_investment_commission[percentage_commission][bonus]" placeholder="<?php echo e(__('admin.placeholder.number')); ?>" aria-label="Percentage" aria-describedby="percentage-commission-addon" step="0.01" min="0" max="100" value="<?php echo e(getArrayValue($setting->agent_investment_commission,'percentage_commission.bonus')); ?>">
                                    <span class="input-group-text" id="percentage-commission-addon">%</span>
                                </div>
                            </div>
                        </div>

                        <hr>
                        <!-- Performance-Based Commission Settings -->
                        <div class="row">
                            <h5 class="mt-4 my-3"><?php echo e(__('Performance-Based Commission Settings')); ?></h5>

                            <!-- Performance Threshold Status -->
                            <div class="col-lg-4 mb-3">
                                <label for="performance-status" class="form-label"><?php echo e(__('Performance Threshold Status')); ?> <sup class="text--danger">*</sup></label>
                                <select class="form-select shadow-sm" name="agent_investment_commission[performance_based_commission][status]" id="performance-status" required>
                                    <?php $__currentLoopData = \App\Enums\Status::toArray(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($status); ?>" <?php echo e(getArrayValue($setting->agent_investment_commission,'performance_based_commission.status') == $status ? 'selected' : ''); ?>>
                                            <?php echo e(\App\Enums\Status::getName($status)); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>

                            <!-- Performance Threshold Amount -->
                            <div class="col-lg-4 mb-3">
                                <label for="performance-threshold" class="form-label"><?php echo e(__('Performance Threshold Amount')); ?> <sup class="text--danger">*</sup></label>
                                <div class="input-group shadow-sm">
                                    <input type="number" class="form-control" id="performance-threshold" name="agent_investment_commission[performance_based_commission][threshold]" placeholder="<?php echo e(__('admin.placeholder.number')); ?>" aria-label="Performance Threshold Amount" aria-describedby="performance-threshold-addon" value="<?php echo e(getArrayValue($setting->agent_investment_commission,'performance_based_commission.threshold')); ?>">
                                    <span class="input-group-text" id="performance-threshold-addon"><?php echo e(getCurrencyName()); ?></span>
                                </div>
                            </div>

                            <!-- Performance Bonus -->
                            <div class="col-lg-4 mb-3">
                                <label for="performance-bonus" class="form-label"><?php echo e(__('Performance Bonus')); ?> <sup class="text--danger">*</sup></label>
                                <div class="input-group shadow-sm">
                                    <input type="number" class="form-control" id="performance-bonus" name="agent_investment_commission[performance_based_commission][bonus]" placeholder="<?php echo e(__('admin.placeholder.number')); ?>" aria-label="Performance Bonus" aria-describedby="performance-bonus-addon" value="<?php echo e(getArrayValue($setting->agent_investment_commission,'performance_based_commission.bonus')); ?>">
                                    <span class="input-group-text" id="performance-bonus-addon"><?php echo e(getCurrencyName()); ?></span>
                                </div>
                            </div>
                        </div>

                        <hr>
                        <!-- Monthly-Team Commission Settings -->
                        <div class="row">
                            <h5 class="mt-4 my-3"><?php echo e(__('Monthly Team Investment Commission Settings')); ?></h5>

                            <!-- Monthly Team Investment Status -->
                            <div class="col-lg-4 mb-3">
                                <label for="monthly-status" class="form-label"><?php echo e(__('Monthly Commission Status')); ?> <sup class="text--danger">*</sup></label>
                                <select class="form-select shadow-sm" name="agent_investment_commission[monthly_team_investment_commission][status]" id="monthly-status" required>
                                    <?php $__currentLoopData = \App\Enums\Status::toArray(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($status); ?>" <?php echo e(getArrayValue($setting->agent_investment_commission,'monthly_team_investment_commission.status') == $status ? 'selected' : ''); ?>>
                                            <?php echo e(\App\Enums\Status::getName($status)); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>

                            <!-- Monthly Team Investment Amount -->
                            <div class="col-lg-4 mb-3">
                                <label for="monthly-team-investment" class="form-label"><?php echo e(__('Monthly Team Investment Amount')); ?> <sup class="text--danger">*</sup></label>
                                <div class="input-group shadow-sm">
                                    <input type="number" class="form-control" id="monthly-team-investment" name="agent_investment_commission[monthly_team_investment_commission][monthly_team_investment]" placeholder="<?php echo e(__('admin.placeholder.number')); ?>" aria-label="Monthly Team Investment Amount" aria-describedby="monthly-team-investment-addon" value="<?php echo e(getArrayValue($setting->agent_investment_commission,'monthly_team_investment_commission.monthly_team_investment')); ?>">
                                    <span class="input-group-text" id="monthly-team-investment-addon"><?php echo e(getCurrencyName()); ?></span>
                                </div>
                            </div>

                            <!-- Monthly Team Investment Bonus -->
                            <div class="col-lg-4 mb-3">
                                <label for="monthly-bonus" class="form-label"><?php echo e(__('Monthly Bonus')); ?> <sup class="text--danger">*</sup></label>
                                <div class="input-group shadow-sm">
                                    <input type="number" class="form-control" id="monthly-bonus" name="agent_investment_commission[monthly_team_investment_commission][bonus]" placeholder="<?php echo e(__('admin.placeholder.number')); ?>" aria-label="Monthly Bonus" aria-describedby="monthly-bonus-addon" value="<?php echo e(getArrayValue($setting->agent_investment_commission,'monthly_team_investment_commission.bonus')); ?>">
                                    <span class="input-group-text" id="monthly-bonus-addon"><?php echo e(getCurrencyName()); ?></span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="modal-footer">
                        <div class="d-flex align-items-center gap-3">
                            <button type="button" class="btn btn--outline btn--sm" data-bs-dismiss="modal"> <?php echo e(__('admin.button.cancel')); ?></button>
                            <button type="submit" class="btn btn--primary btn--sm"> <?php echo e(__('admin.button.save')); ?></button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal fade" id="credit-add-return" tabindex="-1" aria-labelledby="credit-add-return" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo e(__('admin.user.content.add_subtract')); ?></h5>
                </div>
                <form action="<?php echo e(route('admin.agent.add-subtract.balance')); ?>" method="POST">
                    <?php echo method_field('PUT'); ?>
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="id" value="">
                    <div class="modal-body">
                        <div class="mb-3">
                            <label for="type" class="form-label"> <?php echo e(__('admin.input.type')); ?> <sup class="text--danger">*</sup></label>
                            <select class="form-select" name="type" id="type" required>
                                <?php $__currentLoopData = \App\Enums\Transaction\Type::toArray(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($status); ?>"><?php echo e(\App\Enums\Transaction\Type::getName($status)); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <div class="mb-3">
                            <label for="amount" class="form-label"> <?php echo e(__('admin.input.amount')); ?> <sup class="text--danger">*</sup></label>
                            <div class="input-group">
                                <input type="number" class="form-control" id="amount" name="amount"
                                       placeholder="<?php echo e(__('admin.placeholder.number')); ?>" aria-label="Recipient's username"
                                       aria-describedby="basic-addon2">
                                <span class="input-group-text" id="basic-addon2"><?php echo e(getCurrencyName()); ?></span>
                            </div>
                        </div>
                    </div>

                    <div class="modal-footer">
                        <div class="d-flex align-items-center gap-3">
                            <button type="button" class="btn btn--outline btn--sm" data-bs-dismiss="modal"> <?php echo e(__('admin.button.cancel')); ?></button>
                            <button type="submit" class="btn btn--primary btn--sm"> <?php echo e(__('admin.button.save')); ?></button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal fade" id="addAgentModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel"><?php echo e(__('Add Agent')); ?></h5>
                </div>
                <form action="<?php echo e(route('admin.agent.store')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-lg-6 mb-3">
                                <label class="form-label" for="name"><?php echo e(__('Name')); ?><sup class="text-danger">*</sup></label>
                                <input type="text" name="name" id="name" class="form-control" placeholder="<?php echo e(__('admin.placeholder.name')); ?>">
                            </div>

                            <div class="col-lg-6 mb-3">
                                <label class="form-label" for="level"><?php echo e(__('Username')); ?><sup class="text-danger">*</sup></label>
                                <input type="text" name="username" id="username" class="form-control" placeholder="<?php echo e(__('Enter Username')); ?>">
                            </div>

                            <div class="col-lg-6 mb-3">
                                <label class="form-label" for="email"><?php echo e(__('Email')); ?><sup class="text-danger">*</sup></label>
                                <input type="text" name="email" id="email" class="form-control" placeholder="<?php echo e(__('Enter email Name')); ?>">
                            </div>

                            <div class="col-lg-6 mb-3">
                                <label class="form-label" for="phone"><?php echo e(__('Phone')); ?><sup class="text-danger">*</sup></label>
                                <input type="text" name="phone" id="phone" class="form-control" placeholder="<?php echo e(__('Enter Phone Number')); ?>">
                            </div>

                            <div class="col-lg-6 mb-3">
                                <label class="form-label" for="password"><?php echo e(__('Password')); ?><sup class="text-danger">*</sup></label>
                                <input type="password" name="password" id="password" class="form-control" placeholder="<?php echo e(__('Enter Password')); ?>">
                            </div>

                            <div class="col-lg-6 mb-3">
                                <label class="form-label" for="password_confirmation"><?php echo e(__('Confirm Password')); ?><sup class="text-danger">*</sup></label>
                                <input type="password" name="password_confirmation" id="password_confirmation" class="form-control" placeholder="<?php echo e(__('Enter Confirm Password')); ?>">
                            </div>
                        </div>
                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn--outline btn--sm" data-bs-dismiss="modal"><?php echo e(__('admin.button.close')); ?></button>
                        <button type="submit" class="btn btn--primary btn--sm"><?php echo e(__('admin.button.save')); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal fade" id="agentUpdateModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel"><?php echo e(__('Update Agent')); ?></h5>
                </div>
                <form action="<?php echo e(route('admin.agent.update')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="id" value="">
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-lg-6 mb-3">
                                <label class="form-label" for="email"><?php echo e(__('Email')); ?></label>
                                <input type="text" name="email" id="email" class="form-control" placeholder="<?php echo e(__('Enter email Name')); ?>">
                            </div>

                            <div class="col-lg-6 mb-3">
                                <label for="status" class="form-label"> <?php echo e(__('admin.input.status')); ?> <sup class="text--danger">*</sup></label>
                                <select class="form-select" name="status" id="status" required>
                                    <?php $__currentLoopData = \App\Enums\Status::toArray(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($status); ?>"><?php echo e(\App\Enums\Status::getName($status)); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>

                            <div class="col-lg-6 mb-3">
                                <label class="form-label" for="password"><?php echo e(__('Password')); ?></label>
                                <input type="password" name="password" id="password" class="form-control" placeholder="<?php echo e(__('Enter Password')); ?>">
                            </div>

                            <div class="col-lg-6 mb-3">
                                <label class="form-label" for="password_confirmation"><?php echo e(__('Confirm Password')); ?></label>
                                <input type="password" name="password_confirmation" id="password_confirmation" class="form-control" placeholder="<?php echo e(__('Enter Confirm Password')); ?>">
                            </div>
                        </div>
                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn--outline btn--sm" data-bs-dismiss="modal"><?php echo e(__('admin.button.close')); ?></button>
                        <button type="submit" class="btn btn--primary btn--sm"><?php echo e(__('admin.button.save')); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script-push'); ?>
    <script>
        "use strict";
        $(document).ready(function () {
            $('.created-update').on('click', function () {
                const modal = $('#credit-add-return');
                const id = $(this).data('id');
                modal.find('input[name=id]').val(id);
                modal.modal('show');
            });


            $('.agentUpdate').on('click', function(event) {
                event.preventDefault();
                const id = $(this).data('id');
                const email = $(this).data('email');
                const status = $(this).data('status');

                const modal = $('#agentUpdateModal');
                modal.find('input[name=id]').val(id);
                modal.find('input[name=email]').val(email);
                modal.find('select[name=status]').val(status);
                modal.modal('show');
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dakehfsw/app.stellenccecapital.com/src/resources/views/admin/agents/index.blade.php ENDPATH**/ ?>