<?php $__env->startSection('panel'); ?>
    <section>
        <div class="card">
            <div class="card-header">
                <h4 class="card-title text-start"><?php echo e(__('admin.notification.content.short_code')); ?></h4>
            </div>
            <div class="responsive-table">
                <table>
                    <thead>
                        <tr>
                            <th><?php echo e(__('admin.table.short_key')); ?></th>
                            <th><?php echo e(__('admin.table.details')); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if($template->short_key): ?>
                            <?php $__currentLoopData = $template->short_key; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>[<?php echo app('translator')->get($key); ?>]</td>
                                    <td><?php echo e(__($value)); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>

            <div class="card-header">
                <h4 class="card-title text-start"><?php echo e(__('admin.notification.content.template_update')); ?></h4>
            </div>

            <form id="setting-form" action="<?php echo e(route('admin.notifications.update',$template->id)); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="card-body">
                    <div class="form-wrapper">
                        <div class="row g-3">
                            <div class="mb-3 col-lg-4">
                                <label for="subject" class="form-label"><?php echo e(__('admin.input.subject')); ?></label>
                                <input type="text" name="subject" value="<?php echo e($template->subject); ?>" class="form-control" id="subject" placeholder="<?php echo app('translator')->get('Enter Subject'); ?>">
                            </div>

                            <div class="mb-3 col-lg-4">
                                <label for="from_email" class="form-label"><?php echo e(__('admin.input.email_from')); ?></label>
                                <input type="text" name="from_email" value="<?php echo e($template->from_email); ?>"  class="form-control" id="from_email" placeholder="<?php echo app('translator')->get('Enter Email From'); ?>">
                            </div>

                            <div class="mb-3 col-lg-4">
                                <label for="status" class="form-label"><?php echo e(__('admin.input.status')); ?></label>
                                <select class="form-select" name="status" id="status" required>
                                    <?php $__currentLoopData = \App\Enums\Status::toArray(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key =>  $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($status); ?>" <?php if($status == $template->status): ?> selected <?php endif; ?>><?php echo e(replaceInputTitle($key)); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>

                            <div class="mb-3 col-lg-12">
                                <label for="mail_template" class="form-label"><?php echo e(__('admin.input.mail_template')); ?></label>
                                <textarea class="form-control" name="mail_template" id="mail_template" cols="30" rows="10"><?php echo e($template->mail_template); ?></textarea>
                            </div>

                            <div class="mb-3 col-lg-12">
                                <label for="sms_template" class="form-label"><?php echo e(__('admin.input.sms_template')); ?><sup class="text-danger">*</sup></label>
                                <textarea class="form-control" name="sms_template" id="sms_template" cols="10" rows="5"><?php echo e($template->sms_template); ?></textarea>
                            </div>
                        </div>
                    </div>
                    <button class="i-btn btn--primary btn--lg"><?php echo e(__('admin.button.save')); ?></button>
                </div>
            </form>
        </div>
    </section>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('admin.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dakehfsw/app.stellenccecapital.com/src/resources/views/admin/notification/edit.blade.php ENDPATH**/ ?>