<?php $__env->startSection('content'); ?>
    <div class="main-content" data-simplebar>
        <h3 class="page-title"><?php echo e(__($setTitle)); ?></h3>
        <div class="i-card-sm">
            <div class="row">
                <div class="user-form">
                    <h5 class="card-header text-center"><?php echo e(__('Payment Details')); ?></h5>
                    <div class="card-body mb-4 mt-2">
                        <?php echo $gateway->details ?? '' ?>
                    </div>
                    <?php if($gateway->type == \App\Enums\Payment\GatewayType::AUTOMATIC->value && $gateway->code == \App\Enums\Payment\GatewayCode::BLOCK_CHAIN->value): ?>
                        <div class="card-body card-body-deposit text-center">
                            <h4 class="my-2"> <?php echo app('translator')->get('PLEASE SEND EXACTLY'); ?> <span class="text-success"> <?php echo e($payment->btc_amount); ?></span> <?php echo app('translator')->get('BTC'); ?></h4>
                            <h5 class="mb-2"><?php echo app('translator')->get('TO'); ?> <span class="text-success"> <?php echo e($payment->btc_wallet ?? ''); ?></span></h5>
                            <img src="<?php echo e(cryptoQRCode($payment->btc_wallet ?? '')); ?>" alt="<?php echo app('translator')->get('Image'); ?>">
                            <h4 class="text-white bold my-4"><?php echo app('translator')->get('SCAN TO SEND'); ?></h4>
                        </div>
                    <?php endif; ?>

                    <?php if($gateway->type == \App\Enums\Payment\GatewayType::MANUAL->value): ?>
                        <div class="col-lg-12 mb-4">
                            <ul class="list-group">
                                <li class="list-group-item d-flex justify-content-between align-items-center">
                                    <?php echo e(__('Rate')); ?>

                                    <span><?php echo e(getCurrencySymbol()); ?>1 =  <?php echo e(shortAmount($payment->rate)); ?> <?php echo e($gateway->currency ?? getCurrencyName()); ?></span>
                                </li>
                                <li class="list-group-item d-flex justify-content-between align-items-center">
                                    <?php echo e(__('Deposit Amount')); ?>

                                    <span><?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount($payment->amount)); ?></span>
                                </li>
                                <li class="list-group-item d-flex justify-content-between align-items-center">
                                    <?php echo e(__('Charge')); ?>

                                    <span><?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount($payment->charge)); ?></span>
                                </li>
                                <li class="list-group-item d-flex justify-content-between align-items-center">
                                    <?php echo e(__('Final Amount')); ?>

                                    <span><?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount($payment->final_amount)); ?></span>
                                </li>
                            </ul>
                        </div>

                        <form method="POST" action="<?php echo e(route('user.payment.traditional')); ?>" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?>
                            <input type="hidden" name="payment_intent" value="<?php echo e($payment->trx); ?>">
                            <input type="hidden" name="gateway_code" value="<?php echo e($gateway->code); ?>">
                            <div class="row">
                                <?php $__currentLoopData = $gateway->parameter; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $parameter): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $parameter = is_array($parameter) ? $parameter : [];
                                    ?>
                                    <div class="col-lg-12">
                                        <div class="form-inner">
                                            <label for="<?php echo e(getArrayValue($parameter,'field_label')); ?>"><?php echo e(__(getArrayValue($parameter,'field_label'))); ?></label>
                                            <?php if(getArrayValue($parameter,'field_type') == 'file'): ?>
                                                <input type="file" id="<?php echo e(getArrayValue($parameter,'field_label')); ?>" name="<?php echo e(getArrayValue($parameter,'field_name')); ?>" required>
                                            <?php elseif(getArrayValue($parameter,'field_type') == 'text'): ?>
                                                <input type="text" id="<?php echo e(getArrayValue($parameter,'field_label')); ?>" name="<?php echo e(getArrayValue($parameter,'field_name')); ?>" placeholder="<?php echo e(__("Enter ". getArrayValue($parameter,'field_label'))); ?>" required>
                                            <?php elseif(getArrayValue($parameter,'field_type') == 'textarea'): ?>
                                                <textarea id="<?php echo e(getArrayValue($parameter,'field_label')); ?>" name="<?php echo e(getArrayValue($parameter,'field_name')); ?>" placeholder="<?php echo e(__("Enter ". getArrayValue($parameter,'field_label'))); ?>" required></textarea>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                            <div class="col-12">
                                <button type="submit" class="i-btn btn--primary btn--lg"><?php echo e(__('Save')); ?></button>
                            </div>
                        </form>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dakehfsw/app.stellenccecapital.com/src/resources/views/payment/preview.blade.php ENDPATH**/ ?>